#!CVSGUI1.0 --selection --name "[ Auto: Update->Lock->Checkout ]"

# +-----------------------------------------------------------------+  
# | TCL                                                             |
# +-----------------------------------------------------------------+
# | Description: This macros automates checking out process         |
# |  in WinCVS.                                                     |
# |  It updates file with the latest version from CVS server        |
# |  then locks the file and finally takes file for editing.        |
# |  Several files could be checked out at once.                    |
# |                                                                 |
# | Installation: Copy this file to /Macros folder of your WinCVS   |
# |  client.                                                        |
# +-----------------------------------------------------------------+
# | Authors: Ruslan Ulanov a.k.a RUS GraFX <rus.grafx@usa.net>      |
# | Web: http://ulanoff.com                                         |
# +-----------------------------------------------------------------+
#
# $Id: UpdateLockEdit.tcl,v 1.3 2003/02/05 10:25:38 rulanov Exp $

cvsexitonerror false

set selList [cvsbrowser get]
set selSize [llength $selList]
set selFailed 0

cvsout "\n-------\[   File checkout processor by RUS GraFX   \]-------\n\n"
cvsout "You've selected " $selSize " file(s)\n\n"
for {set i 0} {$i < $selSize} {incr i} {
    #file tail
    #file dirname
    set file [lindex $selList $i]
    cvsbrowser info $file fileInfo

    cvsout "File: " $fileInfo(name) "...\n"

    cvs -q update $fileInfo(name)
    set errcode [cvslasterrorcode]
    if {[string compare $errcode "0"] == 0} {  
        cvsout "  Successfully updated\n"

        cvs -q admin -l $fileInfo(name)
        set errcode [cvslasterrorcode]
        if {[string compare $errcode "0"] == 0} {  
            cvsout "  Successfully locked\n"
            
            cvs -q edit $fileInfo(name)
            set errcode [cvslasterrorcode]
            if {[string compare $errcode "0"] == 0} {  
                cvsout "  Successfully checked out for editing\n"
            } else {
                set selFailed 1
                cvsout "  Failed to checkout!\n"
            }
            
        } else {
            set selFailed 1
            cvsout "  Failed to lock!\n"
        }
        
    } else {
        set selFailed 1
        cvsout "  Failed to update!\n"
    }
    
}

cvsout "\nDone!\n"

if {$selFailed == 0} {
    cvsout "Enjoy editing!\n"
} else {
    cvsout "> Some errors occured! Look above for details.\n"
}
