#!CVSGUI1.0 --selection --name "[ Auto: Checkin->Unlock ]"

# +-----------------------------------------------------------------+  
# | TCL                                                             |
# +-----------------------------------------------------------------+
# | Description: This macros automates check-in (commit) process    |
# |  in WinCVS.                                                     |
# |  It checks in file to CVS server then clears locks on the file. |
# |  Several files could be checked in at once.                     |
# |                                                                 |
# | Installation: Copy this file to /Macros folder of your WinCVS   |
# |  client.                                                        |
# +-----------------------------------------------------------------+
# | Authors: Ruslan Ulanov a.k.a RUS GraFX <rus.grafx@usa.net>      |
# | Web: http://ulanoff.com                                         |
# +-----------------------------------------------------------------+
#
# $Id: CheckinUnlock.tcl,v 1.2 2003/02/04 02:32:25 rulanov Exp $

cvsexitonerror false

set selList [cvsbrowser get]
set selSize [llength $selList]
set selFailed 0

cvsout "\n-------\[   File checkin processor by RUS GraFX    \]-------\n\n"
cvsout "You've selected " $selSize " file(s)\n\n"
for {set i 0} {$i < $selSize} {incr i} {
    #file tail
    #file dirname
    set file [lindex $selList $i]
    cvsbrowser info $file fileInfo

    cvsout "File: " $fileInfo(name) "...\n"

    if {$fileInfo(modified) == 1} {
    cvs -q commit $fileInfo(name)
    set errcode [cvslasterrorcode]
    if {[string compare $errcode "0"] == 0} {  
        cvsout "  Successfully checked in\n"

        cvs -q admin -u $fileInfo(name)
        set errcode [cvslasterrorcode]
        if {[string compare $errcode "0"] == 0} {  
            cvsout "  Successfully unlocked\n"
            
        } else {
            set selFailed 1
            cvsout "  Failed to unlock!\n"
        }
        
    } else {
        incr selFailed 1
        cvsout "  Failed to check in!\n"
    }

    } else {
        cvsout "File was not changed! Unediting.\n"
        cvs -q unedit $fileInfo(name)
        set errcode [cvslasterrorcode]
        if {[string compare $errcode "0"] == 0} {  
            cvsout "  Successfully unedited\n"

            cvs -q admin -u $fileInfo(name)
            set errcode [cvslasterrorcode]
            if {[string compare $errcode "0"] == 0} {  
                cvsout "  Successfully unlocked\n"
            
            } else {
                set selFailed 1
                cvsout "  Failed to unlock!\n"
            }

        } else {
            incr selFailed
            cvsout "  Failed to unedit!\n"
        }
    }
}

cvsout "\nDone!\n"

if {$selFailed >= 1} {
    cvsout "> \[" $selFailed "\] Some errors occured! Look above for details.\n"
}
